CREATE VIEW HSDDWProductSalesView AS
	SELECT	C.CustomerID,
			C.CustomerName,
			C.City,
			P.ProductNumber,
			P.ProductName,
			T.Year,
			T.QuarterText,
			SUM(PS.Quantity) AS TotalQuantity
	FROM	CUSTOMER C, PRODUCT_SALES PS, PRODUCT P, TIMELINE T
	WHERE	C.CustomerID = PS.CustomerID
		AND P.ProductNumber = PS.ProductNumber
		AND T.TimeID = PS.TimeID
	GROUP BY	C.CustomerID, C.CustomerName, C.City,
				P. ProductNumber, P.ProductName,
				T.QuarterText, T.Year;

/*  ************* USE ORDER BY clause in query *********************/	

SELECT * FROM HSDDWProductSalesView
	ORDER BY	CustomerName, Year, QuarterText;